/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.event;

import com.yurtmod.dimension.TentDimension;
import com.yurtmod.dimension.TentTeleporter;
import com.yurtmod.init.Config;
import com.yurtmod.structure.StructureType;
import net.minecraft.block.BlockBed;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class TentEventHandler {
    @SubscribeEvent
    public void onPlayerWake(PlayerWakeUpEvent event) {
        if (!event.getEntityPlayer().func_130014_f_().field_72995_K) {
            MinecraftServer server = event.getEntityPlayer().func_184102_h();
            WorldServer overworld = server.func_71218_a(0);
            WorldServer tentDim = server.func_71218_a(TentDimension.DIMENSION_ID);
            if (Config.ALLOW_SLEEP_TENT_DIM && TentDimension.isTentDimension(event.getEntityPlayer().func_130014_f_())) {
                this.handleSleepIn(overworld, event.shouldSetSpawn());
                this.handleSleepIn(tentDim, event.shouldSetSpawn());
            }
            tentDim.func_72912_H().func_76068_b(overworld.func_72820_D());
        }
    }

    public void handleSleepIn(WorldServer s, boolean reset) {
        if (reset && s.func_82736_K().func_82766_b("doDaylightCycle")) {
            long i = s.func_72912_H().func_76073_f() + 24000L;
            s.func_72912_H().func_76068_b(i - i % 24000L);
            s.func_72854_c();
        }
    }

    @SubscribeEvent
    public void onTeleport(EnderTeleportEvent event) {
        if (!Config.ALLOW_TELEPORT_TENT_DIM && event.getEntityLiving() instanceof EntityPlayer && TentDimension.isTentDimension(event.getEntityLiving().func_130014_f_()) && !((EntityPlayer)event.getEntityLiving()).func_184812_l_()) {
            event.setCanceled(true);
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            player.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + I18n.func_135052_a((String)"chat.no_teleport", (Object[])new Object[0]), new Object[0]));
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (Config.ALLOW_RESPAWN_INTERCEPT && event.player instanceof EntityPlayerMP) {
            int TENTDIM = TentDimension.DIMENSION_ID;
            boolean RESPAWN = false;
            int CUR_DIM = event.player.func_130014_f_().field_73011_w.getDimension();
            EntityPlayerMP playerMP = (EntityPlayerMP)event.player;
            if (playerMP != null && !playerMP.func_130014_f_().field_72995_K && CUR_DIM == TENTDIM) {
                BlockPos bedPos = playerMP.getBedLocation(TENTDIM);
                if (null == bedPos || !(playerMP.func_130014_f_().func_180495_p(bedPos).func_177230_c() instanceof BlockBed)) {
                    MinecraftServer mcServer = playerMP.func_184102_h();
                    WorldServer oldServer = mcServer.func_71218_a(TENTDIM);
                    WorldServer newServer = mcServer.func_71218_a(0);
                    BlockPos respawnPos = playerMP.getBedLocation(0);
                    respawnPos = respawnPos != null && newServer.func_180495_p(bedPos).func_177230_c() instanceof BlockBed ? EntityPlayerMP.func_180467_a((World)newServer, (BlockPos)respawnPos, (boolean)playerMP.isSpawnForced(0)) : newServer.field_73011_w.getRandomizedSpawnPoint();
                    TentTeleporter tel = new TentTeleporter(TentDimension.DIMENSION_ID, newServer, new BlockPos(0, 0, 0), respawnPos.func_177958_n(), respawnPos.func_177956_o(), respawnPos.func_177952_p(), StructureType.get(0));
                    mcServer.func_184103_al().transferPlayerToDimension(playerMP, 0, (Teleporter)tel);
                } else {
                    return;
                }
            }
        }
    }
}

